// === Browser integration scripts ===

KLContentObject.registerReceiver = function(request, callback)
{
	this.pluginReceiver = request;
	callback();
	/*KLBrowserExtension.callGlobalObject("isProductConnected", null,
		function(isProductConnected) {
			//request.connectionHandler && request.connectionHandler({isProductConnected: isProductConnected});
			callback({isProductConnected: isProductConnected});
		}, true);*/
}

KLContentObject.unregisterReceiver = function()
{
	this.pluginReceiver = null;
}

KLContentObject.onCallFromPlugin = function(callInfo, callback)
{
	if (!this.pluginReceiver) return;
/*	if (callInfo.method == 'bi.setProductConnected') {
		this.pluginReceiver.connectionHandler(callInfo.parameters[0]);
	}
	else {*/
		this.pluginReceiver.callback(callInfo.method, callInfo.parameters);
//	}
}

KLContentObject.onNativeHostDisconnected = function()
{
	if (this.pluginReceiver)
		this.pluginReceiver.errback("native host disconnected");
}

URLAdvisorStatus.statuses = {
    pending : "pending",
    allowed : "allowed",
    blocked : "blocked",
    warning : "warning",
    unknown : "unknown"
};
function URLAdvisorStatus() {
    this.status = URLAdvisorStatus.statuses.pending;
};

KLContentObject.balloons = {};
KLContentObject.initialized = false;

KLContentObject.alertTemplate = ' \
    <div class="urla_alert"> \
        <div class="urla_alert_title"> \
            <div class="urla_alert_title_name">%title_name%</div> \
        </div> \
        <div class="urla_alert_body"> \
            <div class="urla_alert_text_3"> \
                %text_1% \
                <span class="urla_alert_text_link">%short_link%</span> \
                %text_2% \
            </div> \
        </div> \
        <div class="urla_alert_buttons"> \
            <div class="urla_alert_goback_button">%goback_label%</div> \
            <div class="urla_alert_ignore_button" href="%full_link%">%ignore_label%</div> \
        </div> \
    </div> \
';
KLContentObject.balloonCategoryTemplate = ' \
    <div class="urla_balloon_category"> \
        <div class="urla_balloon_category_left"></div> \
        <div class="urla_balloon_category_mid">%category_description%</div> \
        <div class="urla_balloon_category_right"></div> \
    </div> \
';
KLContentObject.balloonCategoryPlaceholder = ' \
    <div class="urla_balloon_category"> \
        <div class="urla_balloon_category_mid"></div> \
    </div> \
';
KLContentObject.termsHrefTemplate = "http://redirect.kaspersky.com/?target=threatcatterms&act-local=%locale%&rpe=1";

KLContentObject.balloonTemplate = ' \
    <div %direction% class="urla_balloon"> \
        <div class="urla_balloon_top %position%"></div> \
        <div class="urla_balloon_mid %position%"> \
            <div class="urla_balloon_title %position% %type%">%title%</div> \
            <div class="urla_balloon_flag %type% %position%"></div> \
            <div class="urla_balloon_text">%text%</div> \
            <div class="urla_balloon_domain"> \
                <div class="urla_balloon_domain_statusIcon %type%"></div> \
                <div class="urla_balloon_domain_url %type%" href="%domain_href%">%domain_text%</div> \
            </div> \
            <div class="urla_balloon_categories"></div> \
        </div> \
        <div class="urla_balloon_bottom %position%"></div> \
    </div> \
';

function Balloon(element, checkStatus) {
    this.checkStatus = checkStatus;
    this.element = element;

    var termsHref = KL.fillTemplate(KLContentObject.termsHrefTemplate, {
        "locale" : Localization.locale
    });
    var makeBalloon = function(position) {
        return KL.fillTemplateAndCreateElement(KLContentObject.balloonTemplate, {
                "direction" : Localization.getString("rtl") === "yes" ? "dir=\"rtl\"" : "",
                "type" : checkStatus.verdict,
                "title" : Localization.getString(checkStatus.verdict + "_title"),
                "text" : Localization.getString(checkStatus.verdict + "_description"),
                "domain_href" : checkStatus.url,
                "domain_text" : KLContentObject.createShortDomainByHref(checkStatus.url),
                "terms_href" : termsHref,
                "terms_text" : Localization.getString("tou_label"),
                "position" : position
            });
    };
    var attachCategories = function(theBalloon) {
        var resolvedLocales = {};
        var appendedCategories = 0;

        [].forEach.call(checkStatus.categories, function(yac) {
            if(yac.length == 0) {
                return;
            }
            var localeLable = Localization.getString("category_" + yac);
            if(typeof resolvedLocales[localeLable] !== "undefined") {
                return;
            }
            if(localeLable == ("category_" + yac) || localeLable.length == 0) {
                KL.logError("no localization for category " + yac);
                return;
            }
            resolvedLocales[localeLable] = true;
            var newCategory = KL.fillTemplateAndCreateElement(KLContentObject.balloonCategoryTemplate, {
                "category_description" : Localization.getString("category_" + yac)
            });
            $(theBalloon.getElement()).find(".urla_balloon_categories").append(newCategory);
            appendedCategories++;
        });

        if(appendedCategories == 0) {
            /* add single table cell with empty content for better looking  balloon */
            attachPlaceholderCategory(thisBalloon);
        }
    };
    var attachPlaceholderCategory = function(theBalloon) {
        var placeholderCategory = KL.fillTemplateAndCreateElement(KLContentObject.balloonCategoryPlaceholder, {});
        $(theBalloon.getElement()).find(".urla_balloon_categories").append(placeholderCategory);
    };

    var thisBalloon = this;
    // It is necessary to create and remove balloon to get it's real height with all categories
    this.balloonElement = makeBalloon(this.position);
    attachCategories(thisBalloon);
    $(element).after(this.balloonElement);
    this.position = Balloon.calculatePosition(element,
                                              this.balloonElement[0].offsetHeight,
                                              this.balloonElement[0].offsetWidth);
    $(this.balloonElement).remove();
    this.balloonElement = makeBalloon(this.position);
    attachCategories(thisBalloon);

    $(document.body).after(this.balloonElement);
    $(this.balloonElement).mouseover(function() {
        thisBalloon.hovered = true;
        thisBalloon.goToCorrectPosition();
    });
    $(this.balloonElement).mouseout(function() {
        thisBalloon.hovered = false;
        setTimeout(function() {
            if(!thisBalloon.hovered) {
                thisBalloon.getElement().classList.remove("fade_in");
                thisBalloon.getElement().classList.add("fade_out");
                thisBalloon.goOffscreen();
            }
        }, 100);
    });

    // [TODO] get rid of magic numbers
    if(this.position.split("_")[0] == "top")
        this.balloonElement.top = $(element).offset().top + element.offsetHeight + 10;
    else
        this.balloonElement.top = $(element).offset().top - this.balloonElement[0].offsetHeight;
    if(this.position.split("_")[1] == "right")
        this.balloonElement.left = $(element).offset().left - element.offsetWidth - 13;
    else
        this.balloonElement.left = $(element).offset().left - this.balloonElement[0].offsetWidth + 50;
};
Balloon.prototype.getPackedCategories = function() {
    // [FIXME] copypasted from URL Advisor 1.0
    var act_content_cat = [0x00000000, "", ""];
    var categories = this.checkStatus.categories;
    var category_appended = false;
    for(var i = 0; i < categories.length-1; i++) {
        if(categories[i].length > 0) {
            // Hacks, hacks, I love hacks
            var long_numbers = {"15"    : "4611686018427387904",
                                "16"    : "9223372036854775808",
                                "15&16" : "13835058055282163712"}

            if(categories[i] == "15" || categories[i] == "16")
                if(act_content_cat[1] == "")
                    act_content_cat[1] = long_numbers[categories[i]];
                else
                    act_content_cat[1] = long_numbers["15&16"];
            else
                act_content_cat[0] += Math.pow(2, parseInt(categories[i]));
        }
    }

    // Preparing long int
    if(act_content_cat[1] == "") {
        act_content_cat[2] = act_content_cat[0];
    }
    else {
        var tail = parseInt(act_content_cat[1].substr(act_content_cat[1].length-6, 6));
        tail += parseInt(act_content_cat[0]);
        act_content_cat[2] = act_content_cat[1].substring(0, act_content_cat[1].length-6) + tail;
    }
    return act_content_cat[2];
};
Balloon.prototype.getElement = function() {
    return this.balloonElement[0];
};
Balloon.prototype.goToCorrectPosition = function() {
    $(this.balloonElement).offset({
        top: this.balloonElement.top,
        left: this.balloonElement.left
    });
};
Balloon.prototype.goOffscreen = function() {
    var thisBalloon = this.balloonElement;
    setTimeout(function() {
        $(thisBalloon).offset({
            top: -10000,
            left: -10000
        });
    }, 50);
};
Balloon.calculatePosition = function(element, height, width) {
    var box = element.getBoundingClientRect();
    var position_v = "";
    var position_h = "";

    if(box.top >= (height + 40))
        position_v = "bottom";
    else
        position_v = "top";

    if(box.right < width)
        position_h = "right";
    else
        position_h = "left";

    return position_v + "_" + position_h;
};
KLContentObject.wellKnownSearchEngines = [
    "google",
    "yandex",
    "rambler",
    "mail",
    "baidu",
    "bing",
    "nigma",
    "yahoo",
    "sputnik",
    "duckuckgo",
    "ask"
];
KLContentObject.isLocationWellKnownSearchEngine = function(href) {
    var isWNSE = false;
    var prefix = "";
    var trimmedHref = prefix + KLContentObject.createShortDomainByHref(href);
    [].forEach.call(KLContentObject.wellKnownSearchEngines, function(yawnse) {
        isWNSE = isWNSE || (trimmedHref.indexOf(prefix + yawnse) !== -1);
    });
    return isWNSE;
};
KLContentObject.appendMarkToElementWithVerdict = function(element, checkStatus) {
    if(element.hasAttribute("is_urla_self_link")) return;

    var nextElement = $(element).next();
    if(nextElement.length > 0 && nextElement[0].classList.contains("url_mark")) {
        KL.debugMessage("remove old mark");
        $(element).next().remove();
    }

    // [FIXME] Firefox settings workaround
    if(typeof KLContentObject.settings === "undefined")
        KLContentObject.settings = KLBrowserExtension.preferences;

    // KLContentObject.ignoreSettings = true;
    var wellKnownSearchEngineDomain = KLContentObject.isLocationWellKnownSearchEngine(location.href);
    if(KLContentObject.ignoreSettings || KLContentObject.settings.showImage_option &&
       URLAdvisorStatus.statuses[checkStatus.verdict] !== URLAdvisorStatus.statuses.unknown &&
       (URLAdvisorStatus.statuses[checkStatus.verdict] !== URLAdvisorStatus.statuses.allowed ||
       (KLContentObject.settings.showAllowedLinks_option && wellKnownSearchEngineDomain))) {

        var newMark = document.createElement("div");
        newMark.classList.add("urla_mark");
        newMark.classList.add(URLAdvisorStatus.statuses[checkStatus.verdict]);

        $(newMark).mouseover(function() {
            if(typeof KLContentObject.balloons[KLContentObject.createAnchorId(element)] === "undefined") {
                var newBalloon = new Balloon(this, checkStatus); // self attached balloon
                KLContentObject.balloons[KLContentObject.createAnchorId(element)] = newBalloon;
            }
            KLContentObject.balloons[KLContentObject.createAnchorId(element)].getElement().classList.remove("fade_out");
            KLContentObject.balloons[KLContentObject.createAnchorId(element)].getElement().classList.add("fade_in");
            KLContentObject.balloons[KLContentObject.createAnchorId(element)].goToCorrectPosition();
        });
        $(newMark).mouseout(function() {
            setTimeout(function() {
                if(typeof KLContentObject.balloons[KLContentObject.createAnchorId(element)].hovered === "undefined" || !KLContentObject.balloons[KLContentObject.createAnchorId(element)].hovered) {
                    KLContentObject.balloons[KLContentObject.createAnchorId(element)].getElement().classList.remove("fade_in");
                    KLContentObject.balloons[KLContentObject.createAnchorId(element)].getElement().classList.add("fade_out");
                    KLContentObject.balloons[KLContentObject.createAnchorId(element)].goOffscreen();
                }
            }, 100);
        });

        $(element).after(newMark);
        $(newMark).offset({
            top: $(element).offset().top, // + element.offsetHeight,
            left: $(element).offset().left + element.offsetWidth + newMark.offsetWidth
        });

        if(URLAdvisorStatus.statuses[checkStatus.verdict] === URLAdvisorStatus.statuses.blocked) {

            $(element).click(function() {
                var newAlert = KL.fillTemplateAndCreateElement(KLContentObject.alertTemplate, {
                    "title_creator" : Localization.getString("extension_author"),
                    "title_name"    : Localization.getString("extension_name"),
                    "text_1" : Localization.getString("popup_msg_1"),
                    "text_2" : Localization.getString("popup_msg_2"),
                    "urla_alert_text_link" : checkStatus.url,
                    "short_link" : checkStatus.url,
                    "ignore_label" : Localization.getString("ignore_warning_button"),
                    "goback_label" : Localization.getString("go_back_button"),
                    "full_link" : checkStatus.url

                });
                $(document.body).append(newAlert);

                // attach event handlers
                $(".urla_alert_goback_button").click(function() {
                    $(".urla_alert").remove();
                });
                $(".urla_alert_ignore_button").click(function() {
                    window.location.href = checkStatus.url;
                });

                return false;
            });
        }
    }
};
KLContentObject.createAnchorId = function(anch) {
    return anch.href + " " + anch.text + " " + $(anch).offset().top + " " + $(anch).offset().left;
};
KLContentObject.handleDomainCheck = function(checkStatus) {
    if(typeof checkStatus === "undefined") {
        // [FIXME] This is really weired
        return;
    }

    KLContentObject.scannedUrls[checkStatus.url] = {};
    KLContentObject.scannedUrls[checkStatus.url].status = URLAdvisorStatus.statuses[checkStatus.verdict];
    KLContentObject.scannedUrls[checkStatus.url].checkStatus = checkStatus;

    var replaced = checkStatus.url.replace(/\/$/gm,'');

    var selectorQuery = "a[href='" + checkStatus.url + "'],a[href='" + replaced + "']";
    if(KLContentObject.isLocationWellKnownSearchEngine(location.href)) {
        KL.debugMessage(KLContentObject.createShortDomainByHref(checkStatus.url));
        selectorQuery += ",a[href*='%3a%2f%2f" + KLContentObject.createShortDomainByHref(checkStatus.url) + "']";
    }
    var affectedAnchors = document.querySelectorAll(selectorQuery);
    [].forEach.call(affectedAnchors, function(yaa) {
        KLContentObject.appendMarkToElementWithVerdict(yaa, checkStatus);
    });
};

KLContentObject.rescanElement = function(element) {
    var allDomains = KLContentObject.findAllDomains(element);
    var domainsToCheck = {};
    var domainsNotToCheck = {};
    [].forEach.call(allDomains, function(yad) {
        if(typeof KLContentObject.scannedUrls[yad] === "undefined") {
            domainsToCheck[yad] = yad;
        }
        else {
            domainsNotToCheck[yad] = yad;
        }
    });
    var domainsToCheckArray = [];
    for(var d in domainsToCheck) {
        if(domainsToCheck.hasOwnProperty(d)) {
            domainsToCheckArray.push(d);
        }
    }
    if(domainsToCheckArray.length > 0) {
        KL.callGlobalObject("checkDomains", { domains : domainsToCheckArray }, function(checkStatuses) {
            if(typeof checkStatuses !== "undefined") {
                var verdicts = typeof checkStatuses.response !== "undefined" ? checkStatuses.response : checkStatuses;
                [].forEach.call(verdicts, function(checkStatus) {
                    KLContentObject.handleDomainCheck(checkStatus);
                });
            }
        }, true);
    }
    for(var d in domainsNotToCheck) {
        if(domainsNotToCheck.hasOwnProperty(d)) {
            if(typeof KLContentObject.scannedUrls[d].checkStatus !== "undefined") {
                KLContentObject.handleDomainCheck(KLContentObject.scannedUrls[d].checkStatus);
            }
        }
    }
};
KLContentObject.createShortDomainByHref = function(href) {
    try {
        return (new URL(href)).hostname.replace(/^www\./gm,'');
    }
    catch(e) {
        return href.replace(/^www\./gm,'');
    }
};
KLContentObject.getAllAnchors = function(element, query) {
    try {
        return element.querySelectorAll(query);
    }
    catch(e) {
        return [];
    }
};
KLContentObject.findAllDomains = function(element) {
    var locationTrim = KLContentObject.createShortDomainByHref(location.href);
    var selectorQuery = 'a[href*=\"://\"]:not([href*=\"' + $.escapeSelector(locationTrim) + '\"])';
    var allAnchors = KLContentObject.getAllAnchors(element, selectorQuery); //$(element).find(selectorQuery) - result into freeze on atlassian and asana. Hope this will help
    var allAffectedAnchors = [];
    [].forEach.call(allAnchors, function(yaa) {
        if(locationTrim.indexOf(KLContentObject.createShortDomainByHref(yaa.href)) == -1 &&
           !KLContentObject.isLocationWellKnownSearchEngine(yaa.href)) {
            allAffectedAnchors.push(yaa);
        }
    });
    if(KLContentObject.isLocationWellKnownSearchEngine(location.href)) {
        var selectorQuery = 'a[href*="://"],a[href*="%3a%2f%2f"]'; // Yahoo workaround
        var allAnchors = $(element).find(selectorQuery);
        [].forEach.call(allAnchors, function(yaa) {
            var splitted = yaa.href.split("://");
            if(splitted.length > 2) {
                allAffectedAnchors.push(splitted[2].split("/")[0]);
                return;
            }
            var splitted = yaa.href.split("%3a%2f%2f");
            if(splitted.length > 1 && !KLContentObject.isLocationWellKnownSearchEngine(splitted[1].split("%2f")[0])) {
                allAffectedAnchors.push(splitted[1].split("%2f")[0]);
                return;
            }
            if(location.href.indexOf("yahoo.com") !== -1) { // another Yahoo workaround
                allAffectedAnchors.push(splitted[1]);
                return;
            }
        });
    }
    return allAffectedAnchors;
};

KLContentObject.onDomainChecked = function(checkStatus) {
    KLContentObject.handleDomainCheck(checkStatus);
};

KLContentObject.onDomainsChecked = function(checkStatuses) {
    [].forEach.call(checkStatuses, function(checkStatus) {
        KLContentObject.handleDomainCheck(checkStatus);
    });
};

KLContentObject.onSettingValue = function(setting) {
    KLContentObject.settings[setting.name] = setting.value;
}

KLContentObject.kbToggle = function(data) {
    if(Keyboard.isVisible == true)
        Keyboard.disappear();
    else
        Keyboard.appear(data);
}

KLContentObject.kbAppear = function(data) {
    Keyboard.appear(data);
}

KLContentObject.fmAppendText = function(text) {
    FocusManager.really_append_text(text);
}

KLContentObject.fmTabPressed = function() {
    FocusManager.really_tab_pressed();
}

KLContentObject.fmBackspacePressed = function() {
    FocusManager.really_backspace("symbol");
}

KLContentObject.fmReturnPressed = function() {
    FocusManager.really_return_pressed();
}

KLContentObject.kbShouldRecalculate = function(recalc) {
    Keyboard.recalculate = recalc;
}

KLContentObject.kbUserMoved = function(um) {
    Keyboard.user_moved = um;
}

KLBrowserExtension.launchScriptOnPageLoad(function() {

    KLBrowserExtension.startContextListener();

    KL.callGlobalObject("getSettings", {},
      function(settings) {
        if (typeof settings !== 'undefined')
        {
          KLContentObject.settings = settings;
          setTimeout(function() { Init(); }, 0);
        }
      },
      true);
});

function Init() {

    if (KLContentObject.initialized)
      return;

    KLContentObject.initialized = true;

    setTimeout(function() { FocusManager.parse_for_input(); }, 0);

    // TODO: merge following observers
    var MutationObserverObject = (typeof WebKitMutationObserver === 'undefined')
        ? MutationObserver
        : WebKitMutationObserver;

    if(typeof Keyboard.observer === 'undefined' &&
       (typeof WebKitMutationObserver !== 'undefined' || typeof MutationObserver !== 'undefined')) {
        Keyboard.observer = new MutationObserverObject(function(mutations) {
            setTimeout(function() {
                mutations.forEach(function(mutation) {
                    for (var i = 0; i < mutation.addedNodes.length; i++) {
                        if(document.forms.length > 0 || $(mutation.addedNodes[i]).find('input').length > 0) {
                            console.log("launching FocusManager.parse_for_input on DOM mutation event");
                            FocusManager.parse_for_input();
                            break;
                        }
                    }
                })
            }, 100);
        });

        Keyboard.observer.observe(window.document.body, {
            subtree: true,
            childList: true,
            attribute: true
        });
    }
    
    var cleanChildren = function(element) {
        if (typeof KLContentObject.balloons[KLContentObject.createAnchorId(element)] !== "undefined") {
            $(KLContentObject.balloons[KLContentObject.createAnchorId(element)]).remove();
            delete KLContentObject.balloons[KLContentObject.createAnchorId(element)];
        }
        if (typeof element.children !== "undefined")
            [].forEach.call(element.children, function(newEl) { cleanChildren(newEl); });
    };

    // [TODO] this is safari frame check, use pref from package.json
    KL.debugMessage("KLContentObject.settings.webAVEnabled_option = " + KLContentObject.settings.webAVEnabled_option);
    if(window.top === window && typeof KLContentObject.settings !== 'undefined' && KLContentObject.settings.webAVEnabled_option) {
        KLContentObject.scannedUrls = {};
        KLContentObject.rescanElement(document);

        window.URLAdvisorMutationObserver = new MutationObserverObject(function (mutations) {
            var addedMutatedNodes = [];
            mutations.forEach(function (mutation) {
                if (mutation.addedNodes.length > 0) {
                    [].forEach.call(mutation.addedNodes, function(yan) {
                        KLContentObject.rescanElement(yan);
                    });
                } else {
                    console.log("addedMutatedNodes empty skip");
                }
                [].forEach.call(mutation.removedNodes, function(yan) {
                    cleanChildren(yan);
                });
            });
        });

        window.URLAdvisorMutationObserver.observe(document.body, { subtree: true, childList: true, attribute: true });
    }
    else {
        KL.debugMessage("top window does not match");
    }
};
